object FSynt: TSyntAnalyzer
  Formats = <
    item
      DisplayName = 'Background'
      Font.Charset = DEFAULT_CHARSET
      Font.Color = clWindowText
      Font.Height = -13
      Font.Name = 'Courier New'
      Font.Style = []
      FormatType = ftCustomFont
    end
    item
      DisplayName = 'Identifier'
      Font.Charset = DEFAULT_CHARSET
      Font.Color = clWindowText
      Font.Height = -13
      Font.Name = 'Courier New'
      Font.Style = []
    end
    item
      DisplayName = 'Reserved word'
      Font.Charset = DEFAULT_CHARSET
      Font.Color = clBlue
      Font.Height = -13
      Font.Name = 'Courier New'
      Font.Style = [fsBold]
      ChangeCase = ccUpper
      FormatFlags = [ffBold, ffItalic, ffUnderline, ffStrikeOut, ffReadOnly, ffHidden]
    end
    item
      DisplayName = 'Operators'
      Font.Charset = DEFAULT_CHARSET
      Font.Color = clRed
      Font.Height = -13
      Font.Name = 'Courier New'
      Font.Style = [fsBold]
      ChangeCase = ccUpper
      FormatFlags = [ffBold, ffItalic, ffUnderline, ffStrikeOut, ffReadOnly, ffHidden]
    end
    item
      DisplayName = 'Datatypes'
      Font.Charset = DEFAULT_CHARSET
      Font.Color = clNavy
      Font.Height = -13
      Font.Name = 'Courier New'
      Font.Style = [fsBold]
    end
    item
      DisplayName = 'String'
      Font.Charset = DEFAULT_CHARSET
      Font.Color = clRed
      Font.Height = -13
      Font.Name = 'Courier New'
      Font.Style = []
    end
    item
      DisplayName = 'Comment'
      Font.Charset = DEFAULT_CHARSET
      Font.Color = clGreen
      Font.Height = -13
      Font.Name = 'Courier New'
      Font.Style = []
      MultiLineBorder = True
      FormatFlags = [ffBold, ffItalic, ffUnderline, ffStrikeOut, ffReadOnly]
    end
    item
      DisplayName = 'Symbol'
      Font.Charset = DEFAULT_CHARSET
      Font.Color = clGreen
      Font.Height = -13
      Font.Name = 'Courier New'
      Font.Style = []
    end
    item
      DisplayName = 'Number'
      Font.Charset = DEFAULT_CHARSET
      Font.Color = clOlive
      Font.Height = -13
      Font.Name = 'Courier New'
      Font.Style = []
    end
    item
      DisplayName = 'Marked block'
      Font.Charset = DEFAULT_CHARSET
      Font.Color = clHighlightText
      Font.Height = -13
      Font.Name = 'Courier New'
      Font.Style = []
      BgColor = clHighlight
      FormatType = ftColor
    end
    item
      DisplayName = 'Current Line'
      Font.Charset = DEFAULT_CHARSET
      Font.Color = clWindowText
      Font.Height = -13
      Font.Name = 'Courier New'
      Font.Style = []
      BgColor = clSkyBlue
      FormatType = ftBackGround
    end
    item
      DisplayName = 'Collapsed'
      Font.Charset = DEFAULT_CHARSET
      Font.Color = clNavy
      Font.Height = -13
      Font.Name = 'Courier New'
      Font.Style = [fsBold]
      ChangeCase = ccUpper
      FormatFlags = [ffBold, ffItalic, ffUnderline, ffStrikeOut, ffReadOnly, ffHidden]
    end>
  TokenRules = <
    item
      DisplayName = 'String'
      StyleName = 'String'
      TokenType = 4
      Expression = '".*?("|$)'
      ColumnFrom = 0
      ColumnTo = 0
    end
    item
      DisplayName = 'String 2'
      StyleName = 'String'
      TokenType = 4
      Expression = #39'.*?('#39'|$)'
      ColumnFrom = 0
      ColumnTo = 0
    end
    item
      DisplayName = 'Any name'
      StyleName = 'Identifier'
      TokenType = 2
      Expression = '[a-z_]\w*'
      ColumnFrom = 0
      ColumnTo = 0
    end
    item
      DisplayName = 'Float'
      StyleName = 'Number'
      TokenType = 6
      Expression = '\d+\.?\d+e[\+\-]?\d+|\d+\.\d+'
      ColumnFrom = 0
      ColumnTo = 0
    end
    item
      DisplayName = 'Integer'
      StyleName = 'Number'
      TokenType = 5
      Expression = '\d+'
      ColumnFrom = 0
      ColumnTo = 0
    end
    item
      DisplayName = 'Comment'
      StyleName = 'Comment'
      TokenType = 1
      Expression = '(?s)/\*.*?(\*/|\Z)'#13#10
      ColumnFrom = 0
      ColumnTo = 0
    end
    item
      DisplayName = 'Comment 2'
      StyleName = 'Comment'
      TokenType = 1
      Expression = '--.*'
      ColumnFrom = 0
      ColumnTo = 0
    end
    item
      DisplayName = 'Comment CQL'
      StyleName = 'Comment'
      TokenType = 1
      Expression = '//.*'
      ColumnFrom = 0
      ColumnTo = 0
    end
    item
      DisplayName = 'REM Comment'
      StyleName = 'Comment'
      TokenType = 1
      Expression = 'REM.*'
      ColumnFrom = 0
      ColumnTo = 0
    end
    item
      DisplayName = 'Symbol'
      StyleName = 'Symbol'
      TokenType = 3
      Expression = '[/\*,\.;:\(\)=<>\+\-\[\]]'
      ColumnFrom = 0
      ColumnTo = 0
    end>
  BlockRules = <
    item
      DisplayName = 'Operations'
      StyleName = 'Operators'
      BlockType = btTagDetect
      ConditionList = <
        item
          TagList.Strings = (
            'commit'
            'exception'
            'rollback'
            'savepoint')
          TokenTypes = 4
          IgnoreCase = True
        end>
      HighlightPos = cpBound
      TokenType = 11
      Pen.Color = clRed
      IgnoreAsParent = False
    end
    item
      DisplayName = 'Key words'
      StyleName = 'Reserved word'
      BlockType = btTagDetect
      ConditionList = <
        item
          TagList.Strings = (
            ''
            'add'
            'after'
            'all'
            'alter'
            'analyze'
            'and'
            'any'
            'apply'
            'as'
            'asc'
            'authorize'
            'autoincrement'
            'avg'
            'batch'
            'begin'
            'between'
            'by'
            'cascade'
            'case'
            'clustering'
            'column'
            'columnfamily'
            'comment'
            'compact'
            'compute'
            'consistency'
            'constraint'
            'constraints'
            'count'
            'counter'
            'create'
            'cube'
            'cursor'
            'custom'
            'decimal'
            'declare'
            'delete'
            'desc'
            'distinct'
            'drop'
            'each'
            'each_quorum'
            'else'
            'end'
            'exception'
            'exec'
            'execute'
            'exists'
            'explain'
            'for'
            'foreign'
            'from'
            'function'
            'grant'
            'group'
            'grouping'
            'having'
            'if'
            'in'
            'indentified'
            'index'
            'inner'
            'insert'
            'intersect'
            'interval'
            'into'
            'is'
            'join'
            'key'
            'keyspace'
            'left'
            'level'
            'like'
            'limit'
            'local_one'
            'local_quorum'
            'loop'
            'max'
            'merge'
            'min'
            'minus'
            'modify'
            'month'
            'norecursive'
            'nosuperuser'
            'not'
            'null'
            'of'
            'on'
            'one'
            'open'
            'option'
            'or'
            'order'
            'outer'
            'package'
            'package body'
            'password'
            'permission'
            'permissions'
            'pivot'
            'plan'
            'primary'
            'procedure'
            'quorum'
            'rank'
            'references'
            'replace'
            'replication'
            'return'
            'revoke'
            'role'
            'rollup'
            'row'
            'schema'
            'select'
            'sequence'
            'set'
            'sets'
            'show'
            'sibling'
            'some'
            'statistics'
            'storage'
            'sum'
            'superuser'
            'synonym'
            'table'
            'tablespace'
            'then'
            'three'
            'token'
            'transform'
            'trigger'
            'truncate'
            'ttl'
            'two'
            'type'
            'union'
            'update'
            'use'
            'user'
            'users'
            'using'
            'uuid'
            'values'
            'view'
            'when'
            'where'
            'while'
            'with'
            'within'
            'writetime')
          TokenTypes = 4
          IgnoreCase = True
        end>
      HighlightPos = cpBound
      TokenType = 10
      IgnoreAsParent = False
    end
    item
      DisplayName = 'Functions'
      BlockType = btTagDetect
      ConditionList = <
        item
          TagList.Strings = (
            'ASIN'
            'ATAN'
            'ATAN2'
            'BENCHMARK'
            'BIN'
            'BINARY'
            'BIT_AND'
            'BIT_COUNT'
            'BIT_LENGTH'
            'BIT_OR'
            'BIT_XOR'
            'CAST'
            'CEIL'
            'CEILING'
            'CHAR_LENGTH'
            'CHARACTER_LENGTH'
            'CHARSET'
            'COALESCE'
            'COERCIBILITY'
            'COLLATION'
            'COMPRESS'
            'CONCAT'
            'CONCAT_WS'
            'CONNECTION_ID'
            'CONV'
            'CONVERT_TZ'
            'COS'
            'COT'
            'CRC32'
            'CURDATE'
            'CURRENT_DATE'
            'CURRENT_TIME'
            'CURRENT_TIMESTAMP'
            'CURRENT_USER'
            'CURTIME'
            'DATABASE'
            'DATE_ADD'
            'DATE_FORMAT'
            'DATE_SUB'
            'DATEDIFF'
            'DAY'
            'DAYNAME'
            'DAYOFMONTH'
            'DAYOFWEEK'
            'DAYOFYEAR'
            'DECODE'
            'DEFAULT'
            'DEGREES'
            'DES_DECRYPT'
            'DES_ENCRYPT'
            'DIV'
            'ELT'
            'ENCODE'
            'ENCRYPT'
            'EXP'
            'EXPORT_SET'
            'EXTRACT'
            'FIELD'
            'FIND_IN_SET'
            'FLOOR'
            'FORMAT'
            'FOUND_ROWS'
            'FROM_DAYS'
            'FROM_UNIXTIME'
            'GET_FORMAT'
            'GET_LOCK'
            'GREATEST'
            'GROUP_CONCAT'
            'HEX'
            'HOUR'
            'IFNULL'
            'INET_ATON'
            'INET_NTOA'
            'INSTR'
            'INTERVAL'
            'IS NULL'
            'IS_FREE_LOCK'
            'IS_USED_LOCK'
            'ISNULL'
            'LAST_DAY'
            'LAST_INSERT_ID'
            'LCASE'
            'LEAST'
            'LEFT'
            'LENGTH'
            'LOAD_FILE'
            'LOCALTIME'
            'LOCALTIMESTAMP'
            'LOCATE'
            'LOG'
            'LOG10'
            'LOG2'
            'LPAD'
            'LTRIM'
            'MAKE_SET'
            'MAKEDATE'
            'MAKETIME'
            'MASTER_POS_WAIT'
            'MD5'
            'MICROSECOND'
            'MID'
            'MINUTE'
            'MOD'
            'MONTH'
            'MONTHNAME'
            'NAME_CONST'
            'OCT'
            'OCTET_LENGTH'
            'OLD_PASSWORD'
            'PASSWORD'
            'PERIOD_ADD'
            'PERIOD_DIF'
            'PI'
            'POSITION'
            'POW'
            'POWER'
            'QUARTER'
            'QUOTE'
            'RADIANS'
            'RAND'
            'REGEXP'
            'RELEASE_LOCK'
            'REPLACE'
            'REVERSE'
            'RIGHT'
            'RLIKE'
            'ROUND'
            'ROW_COUNT'
            'RPAD'
            'RTRIM'
            'SCHEMA'
            'SEC_TO_TIME'
            'SECOND'
            'SESSION_USER'
            'SHA1'
            'SIGN'
            'SIN'
            'SLEEP'
            'SOUNDEX'
            'SOUNDS'
            'SPACE'
            'SQRT'
            'STD'
            'STDDEV'
            'STDDEV_POP'
            'STDDEV_SAMP'
            'STR_TO_DATE'
            'STRCMP'
            'SUBDATE'
            'SUBSTR'
            'SUBSTRING'
            'SUBSTRING_INDEX'
            'SUBTIME'
            'SYSTEM_USER'
            'TAN'
            'TIME'
            'TIME_FORMAT'
            'TIME_TO_SEC'
            'TIMEDIFF'
            'TIMESTAMP'
            'TIMESTAMPADD'
            'TIMESTAMPDIFF'
            'TO_DAYS'
            'TRIM'
            'UCASE'
            'UNCOMPRESS'
            'UNCOMPRESSED_LENGTH'
            'UNHEX'
            'UNIX_TIMESTAMP'
            'USER'
            'UTC_DATE'
            'UTC_TIME'
            'UTC_TIMESTAMP'
            'UUID'
            'VAR_POP'
            'VAR_SAMP'
            'VARIANCE'
            'WEEK'
            'WEEKDAY'
            'WEEKOFYEAR'
            'XOR'
            'YEAR'
            'YEARWEEK')
          TokenTypes = 4
          IgnoreCase = True
        end>
      HighlightPos = cpBound
      TokenType = 11
      IgnoreAsParent = False
    end
    item
      DisplayName = 'Datatypes'
      StyleName = 'Datatypes'
      BlockType = btTagDetect
      ConditionList = <
        item
          TagList.Strings = (
            'ASCII'
            'BIGINT'
            'BINARY'
            'BITSTRING'
            'BLOB'
            'BOOLEAN'
            'BYTE'
            'CHAR'
            'COMPLEX'
            'COUNTER'
            'DATE'
            'DATETIME'
            'DECIMAL'
            'DOUBLE'
            'ENUM'
            'FLOAT'
            'INT'
            'INTEGER'
            'INTERVAL'
            'LARGEINT'
            'LONGBLOB'
            'LONGTEXT'
            'MACADDR'
            'MEDIUMBLOB'
            'MEDIUMINT'
            'MEDIUMTEXT'
            'NUMBER'
            'SET'
            'SMALLINT'
            'SYSDATE'
            'TEXT'
            'TIME'
            'TIMESTAMP'
            'TIMESTAMP WITH TIME ZONE'
            'TINYBLOB'
            'TINYINT'
            'UUID'
            'VARBINARY'
            'VARCHAR'
            'VARCHAR2'
            'VARINT'
            'WIDECHAR'
            'WITH TIME ZONE'
            'YEAR')
          TokenTypes = 4
          IgnoreCase = True
        end>
      HighlightPos = cpBound
      TokenType = 11
      Pen.Color = clNavy
      IgnoreAsParent = False
    end
    item
      DisplayName = 'Table or Alias'
      BlockType = btTagDetect
      ConditionList = <
        item
          TagList.Strings = (
            '.')
          TokenTypes = 8
        end
        item
          TokenTypes = 4
        end>
      IdentIndex = 1
      HighlightPos = cpBound
      IgnoreAsParent = False
    end
    item
      DisplayName = 'Alias'
      BlockType = btTagDetect
      ConditionList = <
        item
          TokenTypes = 4
        end
        item
          TagList.Strings = (
            'AS')
          TokenTypes = 2048
          IgnoreCase = True
        end>
      HighlightPos = cpBound
      TokenType = 8
      IgnoreAsParent = False
    end
    item
      DisplayName = 'Alias 2'
      BlockType = btTagDetect
      ConditionList = <
        item
          TokenTypes = 4
        end
        item
          TokenTypes = 4
        end>
      HighlightPos = cpBound
      TokenType = 8
      IgnoreAsParent = False
    end
    item
      DisplayName = 'Table'
      BlockType = btTagDetect
      ConditionList = <
        item
          TagList.Strings = (
            '.')
          CondType = tcNotEqual
          TokenTypes = 8
        end
        item
          TokenTypes = 4
        end>
      IdentIndex = 1
      HighlightPos = cpBound
      TokenType = 7
      IgnoreAsParent = False
    end
    item
      DisplayName = 'Table to Tree'
      ConditionList = <
        item
          TokenTypes = 128
        end
        item
          TagList.Strings = (
            '.')
          CondType = tcNotEqual
          TokenTypes = 8
        end>
      BlockOffset = -1
      NotCollapsed = True
      GroupFmt = 'Used Tables'
      HighlightPos = cpBound
      NoEndRule = True
      IgnoreAsParent = False
    end
    item
      DisplayName = 'Alias to tree'
      ConditionList = <
        item
          TokenTypes = 256
        end
        item
          CondType = tcNotEqual
          TokenTypes = 2048
        end>
      BlockOffset = 1
      NotCollapsed = True
      NameFmt = '%s-1 = %s0'
      GroupFmt = 'Aliases'
      HighlightPos = cpBound
      NoEndRule = True
      TreeItemImage = 1
      IgnoreAsParent = False
    end
    item
      DisplayName = 'Alias to Tree 2'
      ConditionList = <
        item
          TokenTypes = 256
        end
        item
          TokenTypes = 2048
        end>
      NotCollapsed = True
      NameFmt = '%s-1 = %s0'
      GroupFmt = 'Aliases'
      HighlightPos = cpBound
      NoEndRule = True
      TreeItemImage = 1
      IgnoreAsParent = False
    end
    item
      DisplayName = 'Statement start'
      ConditionList = <
        item
          TagList.Strings = (
            'alter'
            'create'
            'declare'
            'delete'
            'drop'
            'group'
            'having'
            'insert'
            'order'
            'pivot'
            'select'
            'transform'
            'union'
            'update'
            'where')
          TokenTypes = 1024
          IgnoreCase = True
        end>
      EndOfTextClose = True
      HighlightPos = cpBound
      DrawStaple = True
      CollapseFmt = '%s0'
      SelfClose = True
      TreeItemImage = 0
      IgnoreAsParent = False
    end
    item
      DisplayName = 'Section End'
      BlockType = btRangeEnd
      ConditionList = <
        item
          TagList.Strings = (
            ';'
            'alter'
            'create'
            'group'
            'having'
            'order'
            'pivot'
            'select'
            'transform'
            'union'
            'where')
          TokenTypes = 1024
          IgnoreCase = True
        end>
      SameIdent = True
      HighlightPos = cpBound
      Pen.Width = 2
      IgnoreAsParent = False
    end
    item
      DisplayName = 'drop'
      ConditionList = <
        item
          TagList.Strings = (
            'create'
            'drop')
          TokenTypes = 1024
          IgnoreCase = True
        end>
      BlockEnd = 'drop end'
      EndOfTextClose = True
      HighlightPos = cpBound
      DrawStaple = True
      CollapseFmt = '%S0 ...'
      SelfClose = True
      IgnoreAsParent = False
    end
    item
      DisplayName = 'drop end'
      BlockType = btRangeEnd
      ConditionList = <
        item
          TagList.Strings = (
            ';')
        end>
      HighlightPos = cpBound
      IgnoreAsParent = False
    end
    item
      DisplayName = 'Insert'
      ConditionList = <
        item
          TagList.Strings = (
            'insert')
          TokenTypes = 1024
          IgnoreCase = True
        end>
      BlockEnd = 'drop end'
      DisplayInTree = False
      HighlightPos = cpBound
      DrawStaple = True
      CollapseFmt = '%S0 ...'
      IgnoreAsParent = False
    end
    item
      DisplayName = 'Comment Start'
      StyleName = 'Comment'
      ConditionList = <
        item
          TokenTypes = 2
        end>
      BlockEnd = 'Comment End'
      HighlightPos = cpAny
      CollapseFmt = '/* ... */'
      IgnoreAsParent = False
    end
    item
      DisplayName = 'Comment End'
      BlockName = 'Comment Start'
      BlockType = btRangeEnd
      ConditionList = <
        item
          CondType = tcNotEqual
          TokenTypes = 2
        end>
      BlockEnd = 'Comment Start'
      HighlightPos = cpAny
      IgnoreAsParent = False
    end
    item
      DisplayName = '('
      StyleName = 'Marked block'
      ConditionList = <
        item
          TagList.Strings = (
            '(')
          TokenTypes = 8
        end>
      BlockEnd = ')'
      NotCollapsed = True
      DisplayInTree = False
      DynHighlight = dhBound
      HighlightPos = cpBound
      DynSelectMin = True
      IgnoreAsParent = False
    end
    item
      DisplayName = ')'
      BlockType = btRangeEnd
      ConditionList = <
        item
          TagList.Strings = (
            ')')
        end>
      HighlightPos = cpAny
      IgnoreAsParent = False
    end
    item
      DisplayName = '['
      StyleName = 'Marked block'
      ConditionList = <
        item
          TagList.Strings = (
            '[')
          TokenTypes = 8
        end>
      BlockEnd = ']'
      NotCollapsed = True
      DisplayInTree = False
      DynHighlight = dhBound
      HighlightPos = cpBound
      DynSelectMin = True
      IgnoreAsParent = False
    end
    item
      DisplayName = ']'
      BlockType = btRangeEnd
      ConditionList = <
        item
          TagList.Strings = (
            ']')
        end>
      HighlightPos = cpAny
      IgnoreAsParent = False
    end
    item
      DisplayName = '{'
      StyleName = 'Marked block'
      ConditionList = <
        item
          TagList.Strings = (
            '{')
          TokenTypes = 8
        end>
      BlockEnd = '}'
      NotCollapsed = True
      DisplayInTree = False
      DynHighlight = dhBound
      HighlightPos = cpBound
      DynSelectMin = True
      IgnoreAsParent = False
    end
    item
      DisplayName = '}'
      BlockType = btRangeEnd
      ConditionList = <
        item
          TagList.Strings = (
            '}')
        end>
      HighlightPos = cpAny
      IgnoreAsParent = False
    end>
  CodeTemplates = <>
  SubAnalyzers = <>
  SampleText.Strings = (
    '-- Demo sample '
    ''
    'DROP TABLE DATA;'
    ''
    'CREATE TABLE DATA '
    ' (ID NUMBER PRIMARY KEY,'
    '  NAME VARCHAR2(50), VALUE VARCHAR2(150)  );'
    ''
    'select '
    #9'Suppliers.CompanyName, Products.ProductName,'
    #9'Products.QuantityPerUnit, Products.UnitPrice, '
    '    OrderDetails.Quantity, Orders.OrderDate, Orders.ShipName'
    'FROM '
    '    Suppliers INNER JOIN Products ON '
    '    Suppliers.SupplierID = Products.SupplierID '
    #9'INNER JOIN OrderDetails ON '
    '    Products.ProductID = OrderDetails.ProductID '
    #9'INNER JOIN Orders ON '
    '    OrderDetails.OrderID = Orders.OrderID'
    'WHERE  '
    #9'Orders.OrderDate > '#39'06/11/1996'#39')')
  TokenTypeNames.Strings = (
    'Unknown'
    'Comment'
    'Identifier'
    'Symbol'
    'String'
    'Integer const'
    'Float const'
    'Table name'
    'Alias'
    'Function'
    'Main KeyWords'
    'Secondary KeyWords')
  MarkedBlockStyle = 'Marked block'
  CurrentLineStyle = 'Current Line'
  DefaultStyleName = 'Background'
  CollapseStyleName = 'Collapsed'
  Extentions = 'sql'
  LexerName = 'SQL'
  SkipSpaces = False
  RestartFromLineStart = True
  LineComment = '--'
  Left = 144
  Top = 184
end
